<?php
// modules/sales/ajax/get_customers.php
session_start();
require_once '../../assets/db_connect.php';

if (!isset($_SESSION['user'])) {
    exit();
}

$shop_id = $_GET['shop_id'] ?? $_SESSION['user']['shop_id'];

$sql = "SELECT * FROM customers WHERE shop_id = ? OR shop_id IS NULL ORDER BY name";
$stmt = $pdo->prepare($sql);
$stmt->execute([$shop_id]);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($customers as $customer) {
    $display = htmlspecialchars($customer['name']);
    if ($customer['phone']) {
        $display .= ' (' . htmlspecialchars($customer['phone']) . ')';
    }
    echo '<option value="' . $customer['id'] . '">' . $display . '</option>';
}